/*
 * Decompiled with CFR 0.152.
 */
package net.forixaim.battle_arts.core_assets.skills.guard;

import java.util.Objects;
import java.util.UUID;
import net.forixaim.battle_arts.core_assets.animations.BattleAnimations;
import net.forixaim.battle_arts.core_assets.capabilities.styles.ImperatriceLumiereStyles;
import net.forixaim.battle_arts.initialization.registry.SkillRegistry;
import net.forixaim.bs_api.battle_arts_skills.BattleArtsSkillSlots;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.phys.Vec3;
import reascer.wom.skill.WOMSkillDataKeys;
import reascer.wom.world.capabilities.item.GesetzCapability;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.particle.EpicFightParticles;
import yesman.epicfight.particle.HitParticleType;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillDataKeys;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.guard.GuardSkill;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.item.WeaponCategory;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.entity.eventlistener.HurtEvent;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class InfernoBulwark
extends GuardSkill {
    private static final UUID EVENT_UUID = UUID.fromString("c5547250-4aa6-44c4-a01e-cf4bd4f8e93b");

    public static GuardSkill.Builder createActiveGuardBuilder() {
        return GuardSkill.createGuardBuilder().addAdvancedGuardMotion((WeaponCategory)CapabilityItem.WeaponCategories.SWORD, (itemCap, playerpatch) -> {
            StaticAnimation[] staticAnimationArray;
            if (itemCap.getStyle((LivingEntityPatch)playerpatch) == ImperatriceLumiereStyles.IMPERATRICE_SWORD) {
                StaticAnimation[] staticAnimationArray2 = new StaticAnimation[2];
                staticAnimationArray2[0] = Animations.SWORD_GUARD_ACTIVE_HIT1;
                staticAnimationArray = staticAnimationArray2;
                staticAnimationArray2[1] = Animations.SWORD_GUARD_ACTIVE_HIT2;
            } else {
                StaticAnimation[] staticAnimationArray3 = new StaticAnimation[2];
                staticAnimationArray3[0] = Animations.SWORD_GUARD_ACTIVE_HIT2;
                staticAnimationArray = staticAnimationArray3;
                staticAnimationArray3[1] = Animations.SWORD_GUARD_ACTIVE_HIT3;
            }
            return staticAnimationArray;
        }).addAdvancedGuardMotion((WeaponCategory)CapabilityItem.WeaponCategories.LONGSWORD, (itemCap, playerpatch) -> new StaticAnimation[]{Animations.LONGSWORD_GUARD_ACTIVE_HIT1, Animations.LONGSWORD_GUARD_ACTIVE_HIT2}).addAdvancedGuardMotion((WeaponCategory)CapabilityItem.WeaponCategories.TACHI, (itemCap, playerpatch) -> new StaticAnimation[]{Animations.LONGSWORD_GUARD_ACTIVE_HIT1, Animations.LONGSWORD_GUARD_ACTIVE_HIT2});
    }

    public InfernoBulwark(GuardSkill.Builder builder) {
        super(builder);
    }

    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.HURT_EVENT_PRE, GuardSkill.EVENT_UUID, 1);
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.CLIENT_ITEM_USE_EVENT, EVENT_UUID, event -> {
            CapabilityItem itemCapability = ((LocalPlayerPatch)event.getPlayerPatch()).getHoldingItemCapability(InteractionHand.MAIN_HAND);
            if (this.isHoldingWeaponAvailable(event.getPlayerPatch(), itemCapability, GuardSkill.BlockType.GUARD)) {
                ((LocalPlayer)((LocalPlayerPatch)event.getPlayerPatch()).getOriginal()).m_6672_(InteractionHand.MAIN_HAND);
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.SERVER_ITEM_STOP_EVENT, EVENT_UUID, event -> {});
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.SERVER_ITEM_USE_EVENT, EVENT_UUID, event -> {
            CapabilityItem itemCapability = ((ServerPlayerPatch)event.getPlayerPatch()).getHoldingItemCapability(InteractionHand.MAIN_HAND);
            if (((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).f_19797_ - (Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.LAST_ACTIVE.get()) > 20) {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.PARRYING.get(), (Object)false, (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
            }
            if (!((Boolean)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.PARRYING.get())).booleanValue() && ((ServerPlayerPatch)event.getPlayerPatch()).getStamina() > 0.0f) {
                if (this.isHoldingWeaponAvailable(event.getPlayerPatch(), itemCapability, GuardSkill.BlockType.ADVANCED_GUARD) && ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).f_19797_ - (Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.LAST_ACTIVE.get()) > 20 && !((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_21255_() && ((ServerPlayerPatch)event.getPlayerPatch()).currentLivingMotion != LivingMotions.FALL && ((ServerPlayerPatch)event.getPlayerPatch()).getEntityState().canUseSkill() && ((ServerPlayerPatch)event.getPlayerPatch()).getEntityState().canBasicAttack()) {
                    StaticAnimation animation = BattleAnimations.IMPERATRICE_GUARD;
                    ((ServerPlayerPatch)event.getPlayerPatch()).consumeForSkill((Skill)this, Skill.Resource.STAMINA, 3.0f, true);
                    ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_9236_().m_6263_(null, ((Player)container.getExecuter().getOriginal()).m_20185_(), ((Player)container.getExecuter().getOriginal()).m_20186_(), ((Player)container.getExecuter().getOriginal()).m_20189_(), (SoundEvent)EpicFightSounds.CLASH.get(), ((Player)container.getExecuter().getOriginal()).m_5720_(), 1.0f, 2.0f);
                    ((ServerPlayerPatch)event.getPlayerPatch()).playAnimationSynchronized(animation, 0.0f);
                    ((ServerPlayerPatch)event.getPlayerPatch()).currentLivingMotion = LivingMotions.BLOCK;
                    container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.LAST_ACTIVE.get(), (Object)((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).f_19797_, (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
                    container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.PARRYING.get(), (Object)true, (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
                } else if (this.isHoldingWeaponAvailable(event.getPlayerPatch(), itemCapability, GuardSkill.BlockType.ADVANCED_GUARD) && ((ServerPlayerPatch)event.getPlayerPatch()).getEntityState().canBasicAttack()) {
                    ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_9236_().m_6263_(null, ((Player)container.getExecuter().getOriginal()).m_20185_(), ((Player)container.getExecuter().getOriginal()).m_20186_(), ((Player)container.getExecuter().getOriginal()).m_20189_(), SoundEvents.f_12031_, ((Player)container.getExecuter().getOriginal()).m_5720_(), 1.0f, 2.0f);
                    container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.LAST_ACTIVE.get(), (Object)(((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).f_19797_ - 4), (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
                }
            }
            if (this.isHoldingWeaponAvailable(event.getPlayerPatch(), itemCapability, GuardSkill.BlockType.ADVANCED_GUARD) && (((ServerPlayerPatch)event.getPlayerPatch()).getStamina() == 0.0f || ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).f_19797_ - (Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.LAST_ACTIVE.get()) > 10) && ((ServerPlayerPatch)event.getPlayerPatch()).getEntityState().canBasicAttack()) {
                ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_9236_().m_6263_(null, ((Player)container.getExecuter().getOriginal()).m_20185_(), ((Player)container.getExecuter().getOriginal()).m_20186_(), ((Player)container.getExecuter().getOriginal()).m_20189_(), SoundEvents.f_12031_, ((Player)container.getExecuter().getOriginal()).m_5720_(), 1.0f, 2.0f);
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.LAST_ACTIVE.get(), (Object)(((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).f_19797_ - 4), (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
            }
            if (this.isHoldingWeaponAvailable(event.getPlayerPatch(), itemCapability, GuardSkill.BlockType.GUARD)) {
                ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_6672_(InteractionHand.MAIN_HAND);
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.HURT_EVENT_PRE, EVENT_UUID, event -> {
            CapabilityItem itemCapability = ((ServerPlayerPatch)event.getPlayerPatch()).getHoldingItemCapability(((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_7655_());
            if (((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).f_19797_ - (Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.LAST_ACTIVE.get()) < 10 && ((Boolean)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.PARRYING.get())).booleanValue()) {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.PARRYING.get(), (Object)false, (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
                DamageSource damageSource = (DamageSource)event.getDamageSource();
                boolean isFront = false;
                Vec3 sourceLocation = damageSource.m_7270_();
                if (sourceLocation != null) {
                    Vec3 viewVector = ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_20252_(1.0f);
                    Vec3 toSourceLocation = sourceLocation.m_82546_(((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_20182_()).m_82541_();
                    if (toSourceLocation.m_82526_(viewVector) > 0.0) {
                        isFront = true;
                    }
                }
                if (isFront) {
                    float impact = 0.5f;
                    float knockback = 0.25f;
                    if (event.getDamageSource() instanceof EpicFightDamageSource) {
                        impact = ((EpicFightDamageSource)event.getDamageSource()).getImpact();
                        knockback += Math.min(impact * 0.1f, 1.0f);
                    }
                    this.guard(container, itemCapability, (HurtEvent.Pre)event, knockback, impact, false);
                }
            } else if (super.isHoldingWeaponAvailable(event.getPlayerPatch(), itemCapability, GuardSkill.BlockType.GUARD) && ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_6117_()) {
                DamageSource damageSource = (DamageSource)event.getDamageSource();
                boolean isFront = false;
                Vec3 sourceLocation = damageSource.m_7270_();
                if (sourceLocation != null) {
                    Vec3 viewVector = ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_20252_(1.0f);
                    Vec3 toSourceLocation = sourceLocation.m_82546_(((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_20182_()).m_82541_();
                    if (toSourceLocation.m_82526_(viewVector) > 0.0) {
                        isFront = true;
                    }
                }
                if (isFront) {
                    float impact = 0.5f;
                    float knockback = 0.25f;
                    if (event.getDamageSource() instanceof EpicFightDamageSource) {
                        impact = ((EpicFightDamageSource)event.getDamageSource()).getImpact();
                        knockback += Math.min(impact * 0.1f, 1.0f);
                    }
                    this.guard(container, itemCapability, (HurtEvent.Pre)event, knockback, impact, false);
                }
            }
        }, 2);
    }

    public void guard(SkillContainer container, CapabilityItem itemCapability, HurtEvent.Pre event, float knockback, float impact, boolean advanced) {
        DamageSource damageSource;
        if (this.isHoldingWeaponAvailable(event.getPlayerPatch(), itemCapability, GuardSkill.BlockType.ADVANCED_GUARD) && this.isBlockableSource(damageSource = (DamageSource)event.getDamageSource(), true)) {
            float convert;
            ServerPlayer playerentity = (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal();
            int timing = playerentity.f_19797_ - (Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.LAST_ACTIVE.get());
            boolean successParrying = timing < 10;
            float penalty = ((Float)container.getDataManager().getDataValue((SkillDataKey)SkillDataKeys.PENALTY.get())).floatValue();
            ((ServerPlayerPatch)event.getPlayerPatch()).playSound((SoundEvent)EpicFightSounds.CLASH.get(), -0.05f, 0.1f);
            ((HitParticleType)EpicFightParticles.HIT_BLUNT.get()).spawnParticleWithArgument((ServerLevel)playerentity.m_9236_(), HitParticleType.FRONT_OF_EYES, HitParticleType.ZERO, (Entity)playerentity, damageSource.m_7640_());
            if (!(((ServerPlayerPatch)event.getPlayerPatch()).getHoldingItemCapability(InteractionHand.OFF_HAND) instanceof GesetzCapability)) {
                if (successParrying) {
                    penalty = 0.1f;
                    knockback *= 0.4f;
                } else {
                    container.getDataManager().setDataSync((SkillDataKey)SkillDataKeys.PENALTY.get(), (Object)Float.valueOf(penalty += this.getPenalizer(itemCapability)), playerentity);
                }
            }
            if (damageSource.m_7640_() instanceof LivingEntity) {
                knockback += (float)EnchantmentHelper.m_44894_((LivingEntity)((LivingEntity)damageSource.m_7640_())) * 0.1f;
            }
            ((ServerPlayerPatch)event.getPlayerPatch()).knockBackEntity(Objects.requireNonNull(damageSource.m_7640_()).m_20182_(), knockback);
            if (container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CONSUMPTION_VALUE.get()) != null && ((Float)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CONSUMPTION_VALUE.get())).floatValue() != 0.0f) {
                penalty *= ((Float)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CONSUMPTION_VALUE.get())).floatValue();
            }
            boolean enoughStamina = true;
            if (!(((ServerPlayerPatch)event.getPlayerPatch()).getHoldingItemCapability(InteractionHand.OFF_HAND) instanceof GesetzCapability)) {
                if (penalty > 0.0f) {
                    enoughStamina = ((ServerPlayerPatch)event.getPlayerPatch()).consumeForSkill((Skill)this, Skill.Resource.STAMINA, penalty * impact);
                } else {
                    container.getDataManager().setDataSync((SkillDataKey)SkillDataKeys.PENALTY.get(), (Object)Float.valueOf(penalty), playerentity);
                }
            }
            GuardSkill.BlockType blockType = successParrying ? GuardSkill.BlockType.ADVANCED_GUARD : (enoughStamina ? GuardSkill.BlockType.GUARD : GuardSkill.BlockType.GUARD_BREAK);
            StaticAnimation animation = this.getGuardMotion(event.getPlayerPatch(), itemCapability, blockType);
            float f = timing <= 2 ? -0.15f : (convert = timing < 5 ? 0.0f : 0.15f);
            if (animation == Animations.RUSHING_TEMPO2) {
                float f2 = timing <= 2 ? -0.1f : (convert = timing < 5 ? 0.0f : 0.15f);
            }
            if (animation == Animations.SWEEPING_EDGE) {
                float f3 = timing <= 2 ? -0.1f : (convert = timing < 5 ? 0.0f : 0.15f);
            }
            if (blockType == GuardSkill.BlockType.GUARD) {
                convert = 0.0f;
            }
            if (animation != null) {
                ((ServerPlayerPatch)event.getPlayerPatch()).playAnimationSynchronized(animation, convert);
            }
            if (blockType == GuardSkill.BlockType.GUARD_BREAK) {
                ((ServerPlayerPatch)event.getPlayerPatch()).playSound((SoundEvent)EpicFightSounds.NEUTRALIZE_MOBS.get(), 3.0f, 0.0f, 0.1f);
            }
            this.dealEvent(event.getPlayerPatch(), event, advanced);
        }
    }

    public void updateContainer(SkillContainer container) {
        if (!container.getExecuter().isLogicalClient()) {
            ServerPlayerPatch serverPlayerPatch = (ServerPlayerPatch)container.getExecuter();
        }
    }

    public boolean canExecute(PlayerPatch<?> executor) {
        return executor.getSkill((SkillSlot)BattleArtsSkillSlots.BATTLE_STYLE).hasSkill(SkillRegistry.IMPERATRICE_LUMIERE);
    }
}

